IF  EXISTS (SELECT 1 FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_PROD_TBL_DESC_TIPOS]'))
DROP VIEW [dbo].[V_EST_PROD_TBL_DESC_TIPOS]
GO

CREATE VIEW V_EST_PROD_TBL_DESC_TIPOS AS 
SELECT
	1 AS CD_EMP,
	EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_FILIAL,
	EST_PROD_PRECO_DESC_PRG.CD_PRECO_PRG AS CD_TBL_DESC,
	EST_PROD_PRECO_DESC_PRG.NM_PROGRAMACAO AS DS_TBL_DESC,
	EST_PROD_PRECO_DESC_PRG.DT_INI,
	EST_PROD_PRECO_DESC_PRG.DT_VENCTO AS DT_FIM,
	0 AS CD_TP_DESCONTO,
	'DESCONTO PROGRAMADO - ANTIGO' AS DS_TP_DESCONTO,
	EST_PROD_PRECO_DESC_PRG.CD_USU,
	EST_PROD_PRECO_DESC_PRG.DT_CAD,
	EST_PROD_PRECO_DESC_PRG.DT_ULT_ALT,
	1 AS STS_TBL_DESC,
	0 AS ST_PRORROG,
	CD_PROD,
	'EST_PROD_PRECO_DESC_PRG' AS DS_HIERARQUIA,
	EST_PROD_PRECO_DESC_PRG_CPL.PERC_DESC,
	0 AS PERC_MAX,
	0 AS SOBREPOR_OFERTA,
	0 AS PRECO_ESPECIFICO,
	1 AS TP_DESCONTO,
	0 AS FLAG_ENVIO_PROPZ,
	0 AS FLAG_TP_DESCONTO_PROPZ
FROM
	EST_PROD_PRECO_DESC_PRG
INNER JOIN EST_PROD_PRECO_DESC_PRG_CPL ON
	EST_PROD_PRECO_DESC_PRG.CD_PRECO_PRG = EST_PROD_PRECO_DESC_PRG_CPL.CD_PRECO_PRG
INNER JOIN EST_PROD_PRECO_DESC_PRG_PRC_FILIAL ON
	EST_PROD_PRECO_DESC_PRG.CD_PRECO_PRG = EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_PRECO_PRG
WHERE
	EST_PROD_PRECO_DESC_PRG.DT_VENCTO >= CONVERT(CHAR(10), GETDATE(), 112)
	
UNION ALL

SELECT
	EST_PROD_PRECO_OFERTA_PERMANENTE.CD_EMP,
	EST_PROD_PRECO_OFERTA_PERMANENTE.CD_FILIAL,
	0 AS CD_TBL_DESC,
	'DESCONTO OFERTA PERMANENTE' AS DS_TBL_DESC,
	NULL AS DT_INI,
	NULL AS DT_FIM,
	0 AS CD_TP_DESCONTO,
	'DESCONTO PERMANENTE' AS DS_TP_DESCONTO,
	EST_PROD_PRECO_OFERTA_PERMANENTE.CD_USU,
	EST_PROD_PRECO_OFERTA_PERMANENTE.DT_CAD,
	NULL AS DT_ULT_ALT,
	1 AS STS_TBL_DESC,
	0 AS ST_PRORROG,
	CD_PROD,
	'EST_PROD_PRECO_OFERTA_PERMANENTE' AS DS_HIERARQUIA,
	VLR_OFERTA AS PERC_DESC,
	0 AS PERC_DESC_MAX,
	EST_PROD_PRECO_OFERTA_PERMANENTE.SOBREPOR_VLR_OFERTA_ATUAL AS SOBREPOR_OFERTA,
	EST_PROD_PRECO_OFERTA_PERMANENTE.PRECO_ESPECIFICO,
	3 AS TP_DESCONTO,
	0 AS FLAG_ENVIO_PROPZ,
	0 AS FLAG_TP_DESCONTO_PROPZ
FROM
	EST_PROD_PRECO_OFERTA_PERMANENTE

UNION ALL

SELECT 
	EST_PROD_TABLOIDE.CD_EMP,
	EST_PROD_TABLOIDE_FILIAL.CD_FILIAL,
	EST_PROD_TABLOIDE.CD_TABLOIDE AS CD_TBL_DESC,
	EST_PROD_TABLOIDE.DS_DESCRICAO AS DS_TBL_DESC, 
	EST_PROD_TABLOIDE.DT_INICIO AS DT_INI, 
	EST_PROD_TABLOIDE.DT_FIM AS DT_FIM,
	0 AS CD_TP_DESCONTO,
	'TABLOIDE' AS DS_TP_DESCONTO,
	EST_PROD_TABLOIDE.CD_USU,
	EST_PROD_TABLOIDE.DT_CAD,
	EST_PROD_TABLOIDE.DT_ULT_ALT,    
	EST_PROD_TABLOIDE.FLAG_VIGENCIA AS STS_TBL_DESC,
	0 AS ST_PRORROG,
	EST_PROD_TABLOIDE_CPL.CD_PROD,
	'EST_PROD_TABLOIDE' AS DS_HIERARQUIA,
	VLR_GRP_PROD,
	0 AS PERC_DESC_MAX,
	0 AS SOBREPOR_OFERTA,
	0 AS PRECO_ESPECIFICO,
	0 AS TP_DESCONTO,
	0 AS FLAG_ENVIO_PROPZ,
	0 AS FLAG_TP_DESCONTO_PROPZ
FROM 
	EST_PROD_TABLOIDE
INNER JOIN EST_PROD_TABLOIDE_CPL ON 
	EST_PROD_TABLOIDE.CD_EMP = EST_PROD_TABLOIDE_CPL.CD_EMP
	AND EST_PROD_TABLOIDE.CD_TABLOIDE = EST_PROD_TABLOIDE_CPL.CD_TABLOIDE
INNER JOIN EST_PROD_TABLOIDE_FILIAL EST_PROD_TABLOIDE_FILIAL ON
	EST_PROD_TABLOIDE.CD_EMP = EST_PROD_TABLOIDE_FILIAL.CD_EMP
	AND EST_PROD_TABLOIDE.CD_TABLOIDE = EST_PROD_TABLOIDE_FILIAL.CD_TABLOIDE

UNION ALL

SELECT
	EST_PROD.CD_EMP,
	PRC_FILIAL.CD_FILIAL,
	0 AS CD_TBL_DESC,
	'DESCONTO CADASTRO PRODUTO' AS DS_TBL_DESC,
	NULL AS DT_INI,
	NULL AS DT_FIM,
	0 AS CD_TP_DESCONTO,
	'DESCONTO CADASTRO PRODUTO' AS DS_TP_DESCONTO,
	EST_PROD.CD_USU,
	EST_PROD.DT_CAD,
	NULL AS DT_ULT_ALT,
	1 AS STS_TBL_DESC,
	0 AS ST_PRORROG,
	CD_PROD,
	'EST_PROD' AS DS_HIERARQUIA,
	PERC_DESC AS PERC_DESC,
	PERC_DESC_LIMITE AS PERC_DESC_MAX,
	0 AS SOBREPOR_OFERTA,
	0 AS PRECO_ESPECIFICO,
	1 AS TP_DESCONTO,
	0 AS FLAG_ENVIO_PROPZ,
	0 AS FLAG_TP_DESCONTO_PROPZ
FROM
	EST_PROD
INNER JOIN PRC_FILIAL ON
	EST_PROD.CD_EMP = PRC_FILIAL.CD_EMP
WHERE
	EST_PROD.PERC_DESC > 0
	
UNION ALL

SELECT
	EST_PROD_PRECO.CD_EMP,
	EST_PROD_PRECO.CD_FILIAL,
	0 AS CD_TBL_DESC,
	'DESCONTO OFERTA APLICADO' AS DS_TBL_DESC,
	NULL AS DT_INI,
	NULL AS DT_FIM,
	0 AS CD_TP_DESCONTO,
	'DESCONTO OFERTA APLICADO' AS DS_TP_DESCONTO,
	EST_PROD_PRECO.CD_USU,
	EST_PROD_PRECO.DT_CAD,
	NULL AS DT_ULT_ALT,
	1 AS STS_TBL_DESC,
	0 AS ST_PRORROG,
	CD_PROD,
	'EST_PROD_PRECO' AS DS_HIERARQUIA,
	VLR_OFERTA AS PERC_DESC,
	0 AS PERC_DESC_MAX,
	0 AS SOBREPOR_OFERTA,
	0 AS PRECO_ESPECIFICO,
	1 AS TP_DESCONTO,
	0 AS FLAG_ENVIO_PROPZ,
	0 AS FLAG_TP_DESCONTO_PROPZ
FROM
	EST_PROD_PRECO
WHERE
	EST_PROD_PRECO.VLR_OFERTA > 0

UNION ALL

SELECT
	EST_PROD_CPL.CD_EMP,
	EST_PROD_CPL.CD_FILIAL,
	0 AS CD_TBL_DESC,
	'DESCONTO FIDELIDADE FILIAL' AS DS_TBL_DESC,
	NULL AS DT_INI,
	NULL AS DT_FIM,
	0 AS CD_TP_DESCONTO,
	'EST_PROD_CPL' AS DS_TP_DESCONTO,
	EST_PROD_CPL.CD_USU,
	EST_PROD_CPL.DT_CAD,
	NULL AS DT_ULT_ALT,
	1 AS STS_TBL_DESC,
	0 AS ST_PRORROG,
	CD_PROD,
	'EST_PROD_CPL' AS DS_HIERARQUIA,
	0 AS PERC_DESC,
	PERC_DESC_LIMITE AS PERC_DESC_MAX,
	0 AS SOBREPOR_OFERTA,
	0 AS PRECO_ESPECIFICO,
	1 AS TP_DESCONTO,
	0 AS FLAG_ENVIO_PROPZ,
	0 AS FLAG_TP_DESCONTO_PROPZ
FROM
	EST_PROD_CPL
WHERE
	EST_PROD_CPL.PERC_DESC_LIMITE > 0
	
UNION ALL

SELECT
	EST_PROD_PRECO_DESC_CLAS_CLIENTE_PRC_FILIAL.CD_EMP,
	EST_PROD_PRECO_DESC_CLAS_CLIENTE_PRC_FILIAL.CD_FILIAL,
	EST_PROD_PRECO_DESC_CLAS_CLIENTE.CD_PRECO_CLAS_CLIENTE AS CD_TBL_DESC,
	EST_PROD_PRECO_DESC_CLAS_CLIENTE.DS_PRECO_CLAS_CLIENTE AS DS_TBL_DESC,
	NULL AS DT_INI,
	NULL AS DT_FIM,
	0 AS CD_TP_DESCONTO,
	'DESCONTO POR CLASSIFICACAO CLIENTE' AS DS_TP_DESCONTO,
	EST_PROD_PRECO_DESC_CLAS_CLIENTE.CD_USU,
	EST_PROD_PRECO_DESC_CLAS_CLIENTE.DT_CAD,
	EST_PROD_PRECO_DESC_CLAS_CLIENTE.DT_ULT_ALT,
	1 AS STS_TBL_DESC,
	0 AS ST_PRORROG,
	EST_PROD_PRECO_DESC_CLAS_CLIENTE_CPL.CD_PROD,
	'EST_PROD_PRECO_DESC_CLAS_CLIENTE' AS DS_HIERARQUIA,
	EST_PROD_PRECO_DESC_CLAS_CLIENTE_CPL.PERC_DESC,
	EST_PROD_PRECO_DESC_CLAS_CLIENTE_CPL.PERC_DESC_MAX AS PERC_DESC_MAX,
	0 AS SOBREPOR_OFERTA,
	0 AS PRECO_ESPECIFICO,
	1 AS TP_DESCONTO,
	0 AS FLAG_ENVIO_PROPZ,
	0 AS FLAG_TP_DESCONTO_PROPZ
FROM
	EST_PROD_PRECO_DESC_CLAS_CLIENTE
INNER JOIN EST_PROD_PRECO_DESC_CLAS_CLIENTE_CPL ON
	EST_PROD_PRECO_DESC_CLAS_CLIENTE.CD_PRECO_CLAS_CLIENTE = EST_PROD_PRECO_DESC_CLAS_CLIENTE_CPL.CD_PRECO_CLAS_CLIENTE
INNER JOIN EST_PROD_PRECO_DESC_CLAS_CLIENTE_PRC_FILIAL ON
	EST_PROD_PRECO_DESC_CLAS_CLIENTE.CD_PRECO_CLAS_CLIENTE = EST_PROD_PRECO_DESC_CLAS_CLIENTE_PRC_FILIAL.CD_PRECO_CLAS_CLIENTE
	
UNION ALL

SELECT
	RS.CD_EMP,
	EST_PROD_TBL_DESC_PRC_FILIAL.CD_FILIAL,
	RS.CD_TBL_DESC,
	RS.DS_TBL_DESC,
	RS.DT_INI,
	RS.DT_FIM,
	RS.CD_TP_DESCONTO,
	GLB_TP_DESCONTO.DS_TP_DESCONTO,
	RS.CD_USU,
	RS.DT_CAD,
	RS.DT_ULT_ALT,
	RS.STS_TBL_DESC,
	RS.ST_PRORROG,
	RS.CD_PROD,
	RS.DS_HIERARQUIA,
	RS.PERC_DESC,
	RS.PERC_DESC_MAX,
	RS.SOBREPOR_OFERTA,
	RS.PRECO_ESPECIFICO,
	RS.TP_DESCONTO,
	RS.FLAG_ENVIO_PROPZ,
	RS.FLAG_TP_DESCONTO_PROPZ
FROM
	(
	SELECT
		D.CD_EMP,
		D.CD_TBL_DESC,
		D.DS_TBL_DESC,
		D.DT_INI,
		D.DT_FIM,
		D.CD_TP_DESCONTO,
		D.CD_USU,
		D.DT_CAD,
		D.DT_ULT_ALT,
		D.STS_TBL_DESC,
		D.ST_PRORROG,
		A.CD_PROD,
		'LINHA' AS DS_HIERARQUIA,
		CASE
			WHEN L.PERC_DESC_LIMITE > 0 THEN L.PERC_DESC_LIMITE
			ELSE L.PERC_DESC
		END PERC_DESC,
		L.PERC_DESC_MAX,
		0 AS SOBREPOR_OFERTA,
		0 AS PRECO_ESPECIFICO,
		2 AS TP_DESCONTO,
		D.FLAG_ENVIO_PROPZ,
		D.FLAG_TP_DESCONTO_PROPZ
	FROM
		EST_PROD_TBL_DESC D
	INNER JOIN EST_PROD_TBL_DESC_EST_ARV_MERC_LINHA L ON
		D.CD_EMP = L.CD_EMP
		AND D.CD_TBL_DESC = L.CD_TBL_DESC
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON
		L.CD_EMP = A.CD_EMP
		AND L.CD_ARV_MERC_LINHA = A.CD_ARV_MERC_LINHA
	
	UNION ALL
	
	SELECT
		D.CD_EMP,
		D.CD_TBL_DESC,
		D.DS_TBL_DESC,
		D.DT_INI,
		D.DT_FIM,
		D.CD_TP_DESCONTO,
		D.CD_USU,
		D.DT_CAD,
		D.DT_ULT_ALT,
		D.STS_TBL_DESC,
		D.ST_PRORROG,
		A.CD_PROD,
		'CATEGORIA' AS DS_HIERARQUIA,
		CASE
			WHEN C.PERC_DESC_LIMITE > 0 THEN C.PERC_DESC_LIMITE
			ELSE C.PERC_DESC
		END PERC_DESC,
		C.PERC_DESC_MAX,
		0 AS SOBREPOR_OFERTA,
		0 AS PRECO_ESPECIFICO,
		2 AS TP_DESCONTO,
		D.FLAG_ENVIO_PROPZ,
		D.FLAG_TP_DESCONTO_PROPZ
	FROM
		EST_PROD_TBL_DESC D
	INNER JOIN EST_PROD_TBL_DESC_EST_ARV_MERC_CATEGORIA C ON
		D.CD_EMP = C.CD_EMP
		AND D.CD_TBL_DESC = C.CD_TBL_DESC
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON
		C.CD_EMP = A.CD_EMP
		AND C.CD_ARV_MERC_CATEG = A.CD_ARV_MERC_CATEG
	
	UNION ALL
	
	SELECT
		D.CD_EMP,
		D.CD_TBL_DESC,
		D.DS_TBL_DESC,
		D.DT_INI,
		D.DT_FIM,
		D.CD_TP_DESCONTO,
		D.CD_USU,
		D.DT_CAD,
		D.DT_ULT_ALT,
		D.STS_TBL_DESC,
		D.ST_PRORROG,
		P.CD_PROD,
		'FABRICANTE' AS DS_HIERARQUIA,
		CASE
			WHEN F.PERC_DESC_LIMITE > 0 THEN F.PERC_DESC_LIMITE
			ELSE F.PERC_DESC
		END PERC_DESC,
		F.PERC_DESC_MAX,
		0 AS SOBREPOR_OFERTA,
		0 AS PRECO_ESPECIFICO,
		2 AS TP_DESCONTO,
		D.FLAG_ENVIO_PROPZ,
		D.FLAG_TP_DESCONTO_PROPZ
	FROM
		EST_PROD_TBL_DESC D
	INNER JOIN EST_PROD_TBL_DESC_EST_PROD_FABRIC F ON
		D.CD_EMP = F.CD_EMP
		AND D.CD_TBL_DESC = F.CD_TBL_DESC
	INNER JOIN EST_PROD P ON
		F.CD_EMP = P.CD_EMP
		AND F.CD_FABRIC = P.CD_FABRIC
	
	UNION ALL
	
	SELECT
		D.CD_EMP,
		D.CD_TBL_DESC,
		D.DS_TBL_DESC,
		D.DT_INI,
		D.DT_FIM,
		D.CD_TP_DESCONTO,
		D.CD_USU,
		D.DT_CAD,
		D.DT_ULT_ALT,
		D.STS_TBL_DESC,
		D.ST_PRORROG,
		P.CD_PROD,
		'MARCA' AS DS_HIERARQUIA,
		CASE
			WHEN M.PERC_DESC_LIMITE > 0 THEN M.PERC_DESC_LIMITE
			ELSE M.PERC_DESC
		END PERC_DESC,
		M.PERC_DESC_MAX,
		0 AS SOBREPOR_OFERTA,
		0 AS PRECO_ESPECIFICO,
		2 AS TP_DESCONTO,
		D.FLAG_ENVIO_PROPZ,
		D.FLAG_TP_DESCONTO_PROPZ
	FROM
		EST_PROD_TBL_DESC D
	INNER JOIN EST_PROD_TBL_DESC_EST_MC M ON
		D.CD_EMP = M.CD_EMP
		AND D.CD_TBL_DESC = M.CD_TBL_DESC
	INNER JOIN EST_PROD P ON
		M.CD_EMP = P.CD_EMP
		AND M.CD_MC = P.CD_MC
	
	UNION ALL
	
	SELECT
		D.CD_EMP,
		D.CD_TBL_DESC,
		D.DS_TBL_DESC,
		D.DT_INI,
		D.DT_FIM,
		D.CD_TP_DESCONTO,
		D.CD_USU,
		D.DT_CAD,
		D.DT_ULT_ALT,
		D.STS_TBL_DESC,
		D.ST_PRORROG,
		A.CD_PROD,
		'FAMILIA' AS DS_HIERARQUIA,
		CASE
			WHEN E.PERC_DESC_LIMITE > 0 THEN E.PERC_DESC_LIMITE
			ELSE E.PERC_DESC
		END PERC_DESC,
		E.PERC_DESC_MAX,
		0 AS SOBREPOR_OFERTA,
		0 AS PRECO_ESPECIFICO,
		2 AS TP_DESCONTO,
		D.FLAG_ENVIO_PROPZ,
		D.FLAG_TP_DESCONTO_PROPZ
	FROM
		EST_PROD_TBL_DESC D
	INNER JOIN EST_PROD_TBL_DESC_EST_ARV_MERC_FAMILIA E ON
		D.CD_EMP = E.CD_EMP
		AND D.CD_TBL_DESC = E.CD_TBL_DESC
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON
		E.CD_EMP = A.CD_EMP
		AND E.CD_ARV_MERC_FAMILIA = A.CD_ARV_MERC_FAMILIA

	UNION ALL
	
	SELECT
		D.CD_EMP,
		D.CD_TBL_DESC,
		D.DS_TBL_DESC,
		D.DT_INI,
		D.DT_FIM,
		D.CD_TP_DESCONTO,
		D.CD_USU,
		D.DT_CAD,
		D.DT_ULT_ALT,
		D.STS_TBL_DESC,
		D.ST_PRORROG,
		T.CD_PROD,
		'PRODUTO' AS DS_HIERARQUIA,
		CASE
			WHEN T.PERC_DESC_LIMITE > 0 THEN T.PERC_DESC_LIMITE
			ELSE T.PERC_DESC
		END PERC_DESC,
		T.PERC_DESC_MAX,
		0 AS SOBREPOR_OFERTA,
		0 AS PRECO_ESPECIFICO,
		2 AS TP_DESCONTO,
		D.FLAG_ENVIO_PROPZ,
		D.FLAG_TP_DESCONTO_PROPZ
	FROM
		EST_PROD_TBL_DESC D
	INNER JOIN EST_PROD_TBL_DESC_EST_PROD T ON
		D.CD_EMP = T.CD_EMP
		AND D.CD_TBL_DESC = T.CD_TBL_DESC) RS
INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL ON
	RS.CD_EMP = EST_PROD_TBL_DESC_PRC_FILIAL.CD_EMP
	AND RS.CD_TBL_DESC = EST_PROD_TBL_DESC_PRC_FILIAL.CD_TBL_DESC
INNER JOIN GLB_TP_DESCONTO ON
	RS.CD_TP_DESCONTO = GLB_TP_DESCONTO.CD_TP_DESCONTO

UNION ALL

SELECT
	QTD.CD_EMP,
	QTD.CD_FILIAL,
	QTD.CD_TBL_DESC_QTDE,
	QTD.DS_TBL_DESC_QTDE,
	QTD.DT_INI,
	QTD.DT_FIM,
	QTD.CD_TP_DESCONTO,
	QTD.DS_TP_DESCONTO,
	QTD.CD_USU,
	QTD.DT_CAD,
	QTD.DT_ULT_ALT,
	QTD.STS_TBL_DESC,
	QTD.ST_PRORROG,
	QTD.CD_PROD,
	QTD.DS_HIERARQUIA,
	QTD.PERC_DESC,
	QTD.PERC_DESC_MAX,
	QTD.SOBREPOR_OFERTA,
	QTD.PRECO_ESPECIFICO,
	QTD.TP_DESCONTO,
	QTD.FLAG_ENVIO_PROPZ,
	QTD.FLAG_TP_DESCONTO_PROPZ
FROM
	V_EST_PROD_TBL_DESC_QTDE_TIPOS QTD
WHERE
	QTD.STS_TBL_DESC = 1
-- SELECT           
--  D.CD_EMP,           
--  D.CD_TBL_DESC,          
--  D.DS_TBL_DESC,      
--  D.DT_INI,
--  D.DT_FIM,
--  D.CD_TP_DESCONTO,
--  D.CD_USU,
--  D.DT_CAD,
--  D.DT_ULT_ALT,
--  D.STS_TBL_DESC,
--  D.ST_PRORROG,
--  P.CD_PROD,
--  'ESPECIAL - ANIVERSARIO' AS DS_HIERARQUIA,
--   N.PERC_DESC
-- FROM 
-- EST_PROD_TBL_DESC D INNER JOIN EST_PROD_TBL_DESC_EST_PROD_DESC_ANIVER N ON           
--	D.CD_EMP = N.CD_EMP AND
--	D.CD_TBL_DESC = N.CD_TBL_DESC         
-- INNER JOIN EST_PROD P ON
--	N.CD_EMP = P.CD_EMP
--UNION ALL
--SELECT           
--  D.CD_EMP,           
--  D.CD_TBL_DESC,          
--  D.DS_TBL_DESC,      
--  D.DT_INI,
--  D.DT_FIM,
--  D.CD_TP_DESCONTO,
--  D.CD_USU,
--  D.DT_CAD,
--  D.DT_ULT_ALT,
--  D.STS_TBL_DESC,
--  D.ST_PRORROG,
--  P.CD_PROD,
--  'ESPECIAL - CLASSIFICAO CLIENTE' AS DS_HIERARQUIA
-- FROM 
-- EST_PROD_TBL_DESC D INNER JOIN EST_PROD_TBL_DESC_GLB_CLASS_CLIENTE O ON           
--	D.CD_EMP = O.CD_EMP AND
--	D.CD_TBL_DESC = O.CD_TBL_DESC         
-- INNER JOIN EST_PROD P ON
--	O.CD_EMP = P.CD_EMP
--UNION ALL
--SELECT           
--  D.CD_EMP,           
--  D.CD_TBL_DESC,          
--  D.DS_TBL_DESC,      
--  D.DT_INI,
--  D.DT_FIM,
--  D.CD_TP_DESCONTO,
--  D.CD_USU,
--  D.DT_CAD,
--  D.DT_ULT_ALT,
--  D.STS_TBL_DESC,
--  D.ST_PRORROG,
--  P.CD_PROD,
--  'ESPECIAL - QTDE ACIMA' AS DS_HIERARQUIA
-- FROM 
-- EST_PROD_TBL_DESC D INNER JOIN EST_PROD_TBL_DESC_QTDE_ACIMA Q ON           
--	D.CD_EMP = Q.CD_EMP AND
--	D.CD_TBL_DESC = Q.CD_TBL_DESC         
-- INNER JOIN EST_PROD P ON
--	Q.CD_EMP = P.CD_EMP
--UNION ALL
--SELECT           
--  D.CD_EMP,           
--  D.CD_TBL_DESC,          
--  D.DS_TBL_DESC,      
--  D.DT_INI,
--  D.DT_FIM,
--  D.CD_TP_DESCONTO,
--  D.CD_USU,
--  D.DT_CAD,
--  D.DT_ULT_ALT,
--  D.STS_TBL_DESC,
--  D.ST_PRORROG,
--  P.CD_PROD,
--  'ESPECIAL - FORMA DE PAGAMENTO' AS DS_HIERARQUIA
-- FROM 
-- EST_PROD_TBL_DESC D INNER JOIN EST_PROD_TBL_DESC_FORMA_PGTO K ON           
--	D.CD_EMP = K.CD_EMP AND
--	D.CD_TBL_DESC = K.CD_TBL_DESC         
-- INNER JOIN EST_PROD P ON
--	K.CD_EMP = P.CD_EMP
--UNION ALL
--SELECT           
--  D.CD_EMP,           
--  D.CD_TBL_DESC,          
--  D.DS_TBL_DESC,      
--  D.DT_INI,
--  D.DT_FIM,
--  D.CD_TP_DESCONTO,
--  D.CD_USU,
--  D.DT_CAD,
--  D.DT_ULT_ALT,
--  D.STS_TBL_DESC,
--  D.ST_PRORROG,
--  P.CD_PROD,
--  'ESPECIAL - DESC PROGRAMADO' AS DS_HIERARQUIA
-- FROM 
-- EST_PROD_TBL_DESC D INNER JOIN EST_PROD_TBL_DESC_PROGRAMADO Y ON           
--	D.CD_EMP = Y.CD_EMP AND
--	D.CD_TBL_DESC = Y.CD_TBL_DESC         
-- INNER JOIN EST_PROD P ON
--	Y.CD_EMP = P.CD_EMP
--UNION ALL
--SELECT           
--  D.CD_EMP,           
--  D.CD_TBL_DESC_CARGO AS CD_TBL_DESC,          
--  D.DS_TBL_DESC_CARGO AS DS_TBL_DESC,      
--  D.DT_INI,
--  '' DT_FIM,
--  0 AS CD_TP_DESCONTO,
--  D.CD_USU,
--  D.DT_CAD,
--  D.DT_ULT_ALT,
--  D.STS_TBL AS STS_TBL_DESC,
--  0 AS ST_PRORROG,
--  P.CD_PROD,
--  'DESCONTO POR CARGO' AS DS_HIERARQUIA
-- FROM 
-- EST_PROD_TBL_DESC_CARGO D INNER JOIN EST_PROD P ON           
--	D.CD_EMP = P.CD_EMP
-- INNER JOIN FP_CARGO_EST_PROD_TBL_DESC_CARGO Z ON --VINCULO DO CARGO A TABELA DE DESCONTO
--	D.CD_EMP = P.CD_EMP AND
--	D.CD_TBL_DESC_CARGO = Z.CD_TBL_DESC_CARGO
;
